/*This plugin lets you define triggers that can be used to quickly
give your teammates messages that aren't radio commands.  To this make
a text file named triggers.txt and put it in your mods directory.  (NOTE this
plugin has only been tested on a CS server to my knowledge, it should work
with other adminmod supported mods but there are no guarantees).  In that
text file put your triggers and messages in the following format

			trigger;message

To put comments in file use the characters "//" at the beginning of the line
Do not leave blank spaces in this text file

to call your triggers in the game add a "-" to whatever you wrote in the text
file (I am working on making this character user definable)

Plugin created by gnugy, thanks to JhAgA for the idea and suggested
improvements*/

#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>

#define ACCESS_CONSOLE 131071
#define MAX_TRIGGERS 50

/*********************************
*Here is the version number JhAgA*
*********************************/
new STRING_VERSION[MAX_DATA_LENGTH] = "1.11";


//define character to let plugin know message is a trigger here
new Trigchar[MAX_DATA_LENGTH] = "-";

new TriggersFile[MAX_DATA_LENGTH] = "triggers.txt";
new Triggers[MAX_TRIGGERS][MAX_DATA_LENGTH];
new Messages[MAX_TRIGGERS][MAX_DATA_LENGTH];
new NumTrigs = 0; //Holds number of triggers and messages in file

public get_Triggers() {
	new IsFile = 0;
	new LineNum = 0;
	new IsLine;
	new sStr[MAX_DATA_LENGTH];
	new tmpTrig[MAX_DATA_LENGTH];
	new Errormsg[MAX_DATA_LENGTH];

	IsFile = fileexists(TriggersFile);
	if (IsFile > 0) {
		do {
			IsLine = readfile(TriggersFile, sStr, LineNum, MAX_DATA_LENGTH);
			if (IsLine) {
				if (strncmp(sStr, "//", 2) == 0) {
					//Ignore comment
				} else {
		
					strtok(sStr, ";", tmpTrig, MAX_DATA_LENGTH);
					strtok( "", ";", Messages[ NumTrigs ], MAX_DATA_LENGTH);//					say("Second line done")
					strcat(Triggers[ NumTrigs ], Trigchar, MAX_DATA_LENGTH);
					strcat(Triggers[ NumTrigs ], tmpTrig, MAX_DATA_LENGTH);
					NumTrigs++; //Trigger has been added increment NumTrigs
				}
				LineNum++; //Increment LinNum
			}
			if (NumTrigs == MAX_TRIGGERS) {
				return PLUGIN_CONTINUE;
			}
		} while (IsLine);
	} else {
		snprintf(Errormsg, MAX_DATA_LENGTH, "can't find file %s", TriggersFile);
		say(Errormsg);
	}
	return PLUGIN_CONTINUE;
}

public HandleSay(HLCommand, HLData, HLUserName, UserIndex) {
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	new Message[MAX_TEXT_LENGTH];
	new Saymessage[MAX_TEXT_LENGTH];
	new IsTrig = 0;

	convert_string(HLData, Data, MAX_DATA_LENGTH);
	convert_string(HLUserName, User, MAX_NAME_LENGTH);

	IsTrig = findtrig(Data, Message);
	if (IsTrig == 1) {
		snprintf(Saymessage, MAX_TEXT_LENGTH, "say_team %s", Message);
		execclient(User, Saymessage);
		return PLUGIN_HANDLED;
	}
	return PLUGIN_CONTINUE;
}

public findtrig(strSearch[MAX_DATA_LENGTH], Message[MAX_TEXT_LENGTH]) {
	for (new i = 0; i < NumTrigs; i++) {
		if (strcmp(strSearch, Triggers[ i ]) == 0) {
			Message = Messages[ i ];
			return 1;
		}
	}
	Message = "";
	return 0;
}

public plugin_init() {
	plugin_registerinfo("Trigger responce system by Gnugy, for JhAgA", "says messages bases on triggers defined in a text file", STRING_VERSION);
	plugin_registercmd("say", "HandleSay", ACCESS_ALL);
	plugin_registercmd("say_team", "HandleSay", ACCESS_ALL);
	
	get_Triggers();

	return PLUGIN_CONTINUE;
}