/* This plugin enables grapling hook votes and auto-responses. 

 */

/* $Id: plugin_HOOK.sma,v 1.1 4/6/2004 michaelson@smokingservers.com */

#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>

/* Change this to whatever ratio of players need to vote for a setting to change it. */
#define HOOK_VOTE_RATIO 50

/* Change to 1 to have a grapling hook vote start 160 seconds in to a map */
#define AUTO_HOOK_VOTE 1

#define ACCESS_VOTE_HOOK 1

new STRING_VERSION[MAX_DATA_LENGTH] = "2.50.0";

public HOOKVote() {
	new strDummy[10];
	vote("Turn the grapling hook on?", "Yes", "No", "HandleHOOKVote",strDummy);
}

public HandleHOOKVote(WinningOption,HLData,VoteCount,UserCount) {
	new Text[MAX_TEXT_LENGTH];
	new strNumber[MAX_NUMBER_LENGTH];
	new Ratio = HOOK_VOTE_RATIO;
	new strData[MAX_DATA_LENGTH];
	convert_string(HLData, strData,MAX_DATA_LENGTH);
	
	if (VoteCount >= Ratio*UserCount/100) {	
		if (WinningOption==1) {
			if(getvar("DF_hook_on")==1) {
				centersay("Vote over.  The grapling hook will remain enabled.",18,249,244,0);
			} else {
				centersay("Your hook is now active.^nHook away!",18,249,244,0);
				exec("DF_hook_on 1");
			}
		} else {
			if(getvar("DF_hook_on")==1) {
				centersay("OK Ok...You got your way!^nThe grapling hook is unavailable",18,63,187,239);
				exec("DF_hook_on 0");
			} else {
				centersay("Vote over.  The hook will remain disabled.",18,63,187,239);
			}
		}
	} else {
		numtostr(Ratio*UserCount/100,strNumber);
		if(getvar("DF_hook_on")==1) {
			snprintf(Text, MAX_TEXT_LENGTH, "Vote succeeded, but not enough votes for change (needed %s)^ngrapling hook will remain enabled.", strNumber);
		} else {
			snprintf(Text, MAX_TEXT_LENGTH, "Vote succeeded, but not enough votes for change (needed %s)^nThe grapling hook will remain disabled.", strNumber);
		}
		centersay(Text,18,63,187,239);
	}
}

public admin_vote_HOOK(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	
	if (vote_allowed()!=1) {
		selfmessage( "Vote not allowed at this time.");
		return PLUGIN_HANDLED;
	}

	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);
	say_command(User,Command,Data);		
	HOOKVote();
	return PLUGIN_HANDLED;
}

public HandleSay(HLCommand,HLData,HLUserName,UserIndex) {
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];
	
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);

	strstripquotes(Data);
	new Match = FALSE;
	if (strcasestr(Data, "HOOK on")!=-1) {
		Match = TRUE;
	} else if (strcasestr(Data, "HOOK is on")!=-1) {
		Match = TRUE;
	} else if (strcasestr(Data, "grapling hook on")!=-1) {
		Match = TRUE;
	}
	if (Match==TRUE) {
		if (getvar("DF_hook_on") == 1){ 
			centersay ("Don't worry about a ladder, hook away!",7,0,255,0); 
		} else {
			centersay ("The hook is off. Get off your lazy butt and find some stairs!",7,0,255,0);
		}
	}
	if (strcasestr(Data, "vote_HOOK")!=-1) {
		HOOKVote();
	}
	return PLUGIN_CONTINUE;
}


public plugin_init() {
	plugin_registerinfo("Grapling Hook Plugin","Enables grapling hook votes and auto-responses.",STRING_VERSION);
	plugin_registercmd("admin_vote_HOOK","admin_vote_HOOK",ACCESS_VOTE_HOOK,"admin_vote_HOOK : Starts a vote to enable/disable grapling hook.");
	plugin_registercmd("say","HandleSay",ACCESS_ALL);
	plugin_registerhelp("say",ACCESS_ALL,"say HOOK on, HOOK is on, grapling hook on: Will give grapling hook status.");
	
#if AUTO_HOOK_VOTE==1	
	if (vote_allowed()!=1) {
		selfmessage( "Vote not allowed at this time.");
		return PLUGIN_HANDLED;
	}
	set_timer("HOOKVote",160,1);
#endif
		
	return PLUGIN_CONTINUE;
}
