/**************************************************************************************************
***	Plugin_LogD_Redirect	***	by [HDK]DragonReborn	***	[11-03-2001][v1.1]	***
***************************************************************************************************
*
* Instructions
* ------------
* - *** Requires LogD ***
* -Just compile this file and put in your dlls folder for server
*	(ex. c:\sierra\half-life\cstrike\dlls)
* -Then in the plugin.ini file add this line at the bottom:	dlls/plugin_logd_redirect.amx
* -Makes any connecting users during a full server get redirected to the IP specified below
* -On by default at every map change, so change Request =1 to Request = 0 if you don't want that
*
* _________________________________________________________________________________________________
* Commands
* --------
* - admin_redirect <1/0> : turns redirect on/off
*
* -This plugin will not redirect those with ACCESS_IMMUNITY.
* -I used this with NO reserved slots on server.  This plugin compares current PlayerCount to
*  Server Maxplayers.  If they are equal and the player does not have ACCESS_IMMUNITY, the player
*  is routed to the specified server IP and port upon the server reporting "Player entered
*  the game".  This is generally right when the player will start to see the map come on screen,
*  right before the MOTD or the map briefing.
*
* _________________________________________________________________________________________________
* ChangeLog
* ---------
* -NEW to 1.1
*	-Added ability to turn redirect on/off in game using:
*					admin_redirect <1/0>
*
**************************************************************************************************/

#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>

#define ACCESS_CONSOLE 131072
#define ACCESS_REDIRECT 4096

new STRING_VERSION[MAX_DATA_LENGTH] = "1.1";

/*****************************************************************************
*****	This should be set to the IP you want people to be routed to.	******
*****************************************************************************/
new IP[MAX_TEXT_LENGTH] = "24.190.27.13:27015";
/****************************************************************************/

new User[MAX_NAME_LENGTH];
new Request = 1;

public logd_redirect(HLCommand,HLData,HLUserName) {

	new sID[MAX_DATA_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new Count;
	new Count2;

	convert_string(HLData, Data, MAX_DATA_LENGTH);
	strbreak(Data, sID, Data, MAX_DATA_LENGTH);

	new iID = strtonum( sID );
	if( !playerinfo(iID,User,MAX_NAME_LENGTH) ) {
		return PLUGIN_FAILURE;
	}

	Count = maxplayercount();
	Count2 = playercount();

	snprintf(Text,MAX_TEXT_LENGTH,"Maxplayers = %i^nPlayerCount = %i",Count,Count2);
	messageex(User,Text,print_chat);

	if ((playercount() == maxplayercount()) && (Request == 1)) {
		redirect();
	}

	return PLUGIN_HANDLED;
}

public redirect() {

	new Text[MAX_TEXT_LENGTH];

	if (access(ACCESS_IMMUNITY, User) != 1) {
		snprintf(Text,MAX_TEXT_LENGTH,"%s has been routed to other server.",User);
		centersay(Text,10,0,225,0);
		messageex(User,"",print_chat);
		messageex(User,"***************************************************",print_chat);
		messageex(User,"Server is Full, connecting you to next free server.",print_chat);
		messageex(User,"***************************************************",print_chat);
		snprintf(Text,MAX_TEXT_LENGTH,"connect %s",IP);
		execclient(User,Text);
	}else {
				centersay("You were not routed because you have ACCESS_IMMUNITY.",10,0,225,0);
	}
	return PLUGIN_CONTINUE;
}


public admin_redirect(HLCommand,HLData,HLUserName,UserIndex) {

	new Data[MAX_DATA_LENGTH];
	new Toggle;
	
	convert_string(HLData, Data, MAX_DATA_LENGTH);
	
	if (strlen(Data) > 0) {
		Toggle = strtonum(Data);
		if (Toggle == 1) {
			Request = 1;
			selfmessage("[ Redirection has been activated. ]");
			centersay("Redirection has been enabled on the server",5,0,255,0);
		}else if (Toggle == 0) {
			Request = 0;
			selfmessage("[ Redirection has been deactivated. ]");
			centersay("Redirection has been disabled on the server",5,0,255,0);
		}else {
			Toggle = -1;
			selfmessage("[ Command not issued correctly, 1=on, 0=off ]");
		}
	}else {
		selfmessage("[ Command not issued correctly, 1=on, 0=off ]");
	}

	return PLUGIN_HANDLED;

}

public plugin_init() {
	plugin_registerinfo("Plugin_LogD_Redirect","Redirects connections on full servers to another server.",STRING_VERSION);
	plugin_registercmd("logd_redirect", "logd_redirect", ACCESS_CONSOLE, "");
	plugin_registercmd("admin_redirect", "admin_redirect", ACCESS_REDIRECT, "admin_redirect <#>: Toggles player redirection(1=on/0=off)");

	exec( "logd_reg 51 admin_command logd_redirect" );

	return PLUGIN_CONTINUE;
}
