/*
 * Killstreak v1.0beta (May 19th, 2002)
 *
 * Author: <[NN]>Soul (sefanja_severin@hotmail.com, http://nn.kicks-ass.net/)
 * (Ideas and code borrowed from Bud-froggy Productions, all honor to him ;)
 *
 * Announces killstreaks: multi kill, ultra kill, killing spree, monster kill and godlike.
 *
 *
 *
 * IMPORTANT:
 * Place the .wav files in %mod%/sound/misc.
 * Add these lines to all your .res files in the %mod%/maps folder:
 *
 *   sound/misc/multikill.wav
 *   sound/misc/ultrakill.wav
 *   sound/misc/killingspree.wav
 *   sound/misc/monsterkill.wav
 *   sound/misc/godlike.wav
 *
 * If a .res doesn't exist, create one, for example: de_dust.res.
 *
 */

#pragma dynamic 16384

#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>



// Edit these
//
#define FRAG_START_LEVEL 6
#define FRAG_NEXT_LEVEL 3
//
// Stop editing



#define ACCESS_CONSOLE 131072

new STRING_VERSION[MAX_DATA_LENGTH] = "1.0beta";

new FragCount[MAX_PLAYERS] = {0,...};



/* * * * * * * * * * *
 * Helper Functions  *
 * * * * * * * * * * */

playFile(sFileName[])
{
	new TargetIndex;
	new TargetName[MAX_NAME_LENGTH];
	new iTargetID;
	new sTargetID[MAX_NUMBER_LENGTH];

	new MaxPlayerCount = maxplayercount();

	for (TargetIndex = 1; TargetIndex <= MaxPlayerCount; TargetIndex++ )
	{
		if ( playerinfo(TargetIndex,TargetName,MAX_NAME_LENGTH,iTargetID) ) {
			numtostr(iTargetID, sTargetID);
			{
				playsound(sTargetID, sFileName);
			}
		}
	}

	return PLUGIN_CONTINUE;
}



/* * * * * * * * * *
 * LogD Functions  *
 * * * * * * * * * */

public logd_killstreak(HLCommand, HLData, HLUserName, UserIndex)
{
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];

	new iIDA;
	new sIDA[MAX_NUMBER_LENGTH];
	new iIDV;
	new sIDV[MAX_NUMBER_LENGTH];

	new Message[MAX_TEXT_LENGTH];

	convert_string(HLData, Data, MAX_DATA_LENGTH);

	strsplit(Data," ", sIDA,MAX_NUMBER_LENGTH, sIDV,MAX_NUMBER_LENGTH);

	iIDA = strtonum(sIDA);
	iIDV = strtonum(sIDV);

	if( !playerinfo(iIDA,User,MAX_NAME_LENGTH) ) {
		return PLUGIN_HANDLED;
	}

	FragCount[iIDV] = 0;
	FragCount[iIDA] += 1;

	if (FragCount[iIDA] < FRAG_START_LEVEL || (FragCount[iIDA] - FRAG_START_LEVEL) % FRAG_NEXT_LEVEL != 0) {
		return PLUGIN_HANDLED;
	}

	if (FragCount[iIDA] == FRAG_START_LEVEL) {
		playFile("misc/multikill.wav");
		snprintf(Message, MAX_TEXT_LENGTH, "%s: Multi Kill!! (%i frags)", User, FragCount[iIDA]);
		typesay(Message, 6, 255,255,255);
	} else if (FragCount[iIDA] == FRAG_NEXT_LEVEL + FRAG_START_LEVEL) {
		playFile("misc/ultrakill.wav" );
		snprintf(Message, MAX_TEXT_LENGTH, "%s: Ultra Kill!! (%i frags)", User, FragCount[iIDA]);
		typesay(Message, 6, 255,15,255);
	} else if (FragCount[iIDA] == 2 * FRAG_NEXT_LEVEL + FRAG_START_LEVEL) {
		playFile("misc/killingspree.wav");
		snprintf(Message, MAX_TEXT_LENGTH, "%s is on a Killing Spree!! (%i frags)", User, FragCount[iIDA]);
		typesay(Message, 6, 15,255,15);
	} else if (FragCount[iIDA] == 3 * FRAG_NEXT_LEVEL + FRAG_START_LEVEL) {
		playFile("misc/monsterkill.wav");
		snprintf(Message, MAX_TEXT_LENGTH, "%s: Monster Kill!! (%i frags)", User, FragCount[iIDA]);
		typesay(Message, 6, 255,15,15);
	} else {
		playFile("misc/godlike.wav");
		snprintf(Message, MAX_TEXT_LENGTH, "%s is Godlike!! (%i frags)", User, FragCount[iIDA]);
		typesay(Message, 6, 15,128,255);
	}

	return PLUGIN_HANDLED;
}



/* * * * * * * * * * *
 * Handle Functions  *
 * * * * * * * * * * */

public plugin_connect(HLUserName, HLIP, UserIndex)
{
	if (UserIndex >= 1 && UserIndex <= MAX_PLAYERS) {
		FragCount[UserIndex] = 0;
	}

	return PLUGIN_CONTINUE;
}

public plugin_disconnect(HLUserName, UserIndex)
{
	if (UserIndex >= 1 && UserIndex <= MAX_PLAYERS) {
		FragCount[UserIndex] = 0;
	}

	return PLUGIN_CONTINUE;
}

public plugin_init()
{
	plugin_registerinfo("Kill Streak Announcer - by <[NN]>Soul", "Announces kill streaks.", STRING_VERSION);

	plugin_registercmd("logd_killstreak", "logd_killstreak", ACCESS_CONSOLE, "");

	exec("logd_reg 57 admin_command logd_killstreak");

	return PLUGIN_CONTINUE;
}
