
/* Min to Live Plugin (2.0) by Theneb (With help from Zero3Cool) 
   http://www.theneb.co.uk | http://www.zerosplayground.dk/ 

   Please read readme.txt for instructions on using this plugin.    */

#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>

new dayFile[MAX_TEXT_LENGTH] = "addons/adminmod/config/minDay.ini";
new ipsFile[MAX_TEXT_LENGTH] = "addons/adminmod/config/minIps.ini";
new MinToLive = 30;
new hostname[MAX_TEXT_LENGTH] = "hostname";
new url[MAX_TEXT_LENGTH] = "http://www.adminmod.org";

/////////////////////////////////////////////////////////////////////////////////
/* DO NOT MODIFY ANYTHING BELOW THIS LINE, UNLESS YOU KNOW WHAT YOU ARE DOING */
///////////////////////////////////////////////////////////////////////////////

new STRING_VERSION[MAX_DATA_LENGTH] = "2.0";
new UserIP[MAX_PLAYERS][MAX_TEXT_LENGTH];
new MemberFlag[MAX_PLAYERS];


public plugin_connect( HLUserName, HLIP, UserIndex )
{	
	new ipIN[ MAX_TEXT_LENGTH ];
	
	convert_string( HLIP, ipIN, MAX_DATA_LENGTH);
	ipTransform( ipIN, UserIndex);

	ipMemberCheck( UserIndex );
}//end plugin_connect

public ipTransform( ipIN[MAX_TEXT_LENGTH], UserIndex )
{
	new ipByte[4][4];

	strsplit(ipIN,".",ipByte[0],4,ipByte[1],4,ipByte[2],4,ipByte[3],4);

	for(new ipByteCount=0; ipByteCount<4; ipByteCount++)
	{
		if( strtonum( ipByte[ipByteCount] ) < 10 )
		{
			snprintf(ipByte[ipByteCount],4,"00%s",ipByte[ipByteCount]);
		} //end if strtoNum-10
		else
		{
			if( strtonum( ipByte[ipByteCount] ) < 100 )
			{
				snprintf(ipByte[ipByteCount],4,"0%s",ipByte[ipByteCount]);
			} //end if strtoNum-100
		} //end else
	}

	snprintf(UserIP[UserIndex],13,"%s%s%s%s",ipByte[0],ipByte[1],ipByte[2],ipByte[3]);

}//end ipTransform

public ipMemberCheck( UserIndex )
{
	new Line[128];

	MemberFlag[UserIndex] = 0;
	for (new fileReadCount = 1; fileReadCount < (filesize ( ipsFile ) +2 ); fileReadCount++)
	{
		readfile(ipsFile,Line,fileReadCount,64);
			
		if (streq(Line,UserIP[UserIndex])) 
		{
			MemberFlag[UserIndex] = 1;
		}//end MemberCheck if		
	}//end for

}

public admin_min(HLCommand,HLData,HLUserName,UserIndex)
{
	new Min;
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];

	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_DATA_LENGTH);

	Min = strtonum(Data);

	if (Min < 1 || Min > 1440)
	{
		Min = 15;
		messageex(User,"Error: Invalid value. Resetting to 15 minutes.",print_console);
	}//end if
	
	else
	{
		messageex(User,"Minutes to live changed.",print_console);
	}//end else

	return PLUGIN_HANDLED;
}//end admin_min

public Minute()
{
	
	new maxplayers = maxplayercount();
	new Min;
	new Line[64];
	new lineIP[13];
	new lineMin[8];
	new userFlag;
	new sPlayer[32];

	new urlmsg[64];
	snprintf(urlmsg,64,"%s for more details",url, print_type:print_chat);
	
	new Name[MAX_NAME_LENGTH];

	for (new playerCount=1; playerCount<=maxplayers; playerCount++)
	{
					
		playerinfo( playerCount, sPlayer, 32);

		if (playerinfo(playerCount,Name,MAX_NAME_LENGTH) && access(1,sPlayer) && (MemberFlag[playerCount]!=1))
		{
			new statusmsg[64];
			

			for (new fileReadCount=1; fileReadCount < (filesize(dayFile) +1); fileReadCount++)
			{		
				readfile( dayFile , Line, fileReadCount, 64);
				strsplit(Line," ",lineIP,16,lineMin,8);

				
						
				if (streq(lineIP,UserIP[playerCount])) 
				{
					userFlag=1;
					Min = strtonum(lineMin);
					if(Min < 0)
					{
						Min = 0;
					}				


					if(Min >= MinToLive) 
					{
						kick(sPlayer);
					
					}//end if			
					else
					{
						snprintf(Line,64,"%s %i",lineIP,Min+1);
						writefile(dayFile,Line,fileReadCount);
						
						new minutesTil = MinToLive-Min;
						
						if(minutesTil==1)
						{
							snprintf(statusmsg,64,"YOU ARE ABOUT TO BE KICKED IN %i MINUTE, Sorry :(",minutesTil);
						}//end if
						else
						{
							snprintf(statusmsg,64,"%i MINUTES UNTIL WE KICK YOU ",minutesTil);
						}//end else

						

						messageex(sPlayer, statusmsg, print_type:print_chat);
						messageex(sPlayer, "MEMBERS can play for unlimited time", print_type:print_chat);
						messageex(sPlayer, urlmsg, print_type:print_chat);
					}//end else
				}//end if




			} //end for linereader

			if(userFlag==0)
			{
				new dayLine[32];
				new msgWelcome[64];
				new msgKick[64];

				snprintf(msgWelcome,64,"Welcome to %s %s! ",hostname, sPlayer);
				snprintf(msgKick,64,"%i minutes until we KICK you :( ",MinToLive);

				messageex(sPlayer, msgWelcome, print_type:print_chat);
				messageex(sPlayer, "We haven't detected you as a member of this server", print_type:print_chat);
				messageex(sPlayer, msgKick, print_type:print_chat);
				messageex(sPlayer, "Members can play for unlimited time", print_type:print_chat);
				messageex(sPlayer, urlmsg, print_type:print_chat);
				
				lineMin="0";
				Min = strtonum(lineMin);
				snprintf(dayLine,64,"%s %i",UserIP[playerCount],Min);
				
				writefile(dayFile,dayLine,(filesize( dayFile ) +1 ));
				userFlag=1;

			}//end if userFlag
		}//end if
	}//end for
	set_timer("Minute",60,0);
	return PLUGIN_HANDLED;
}//end plugin_minute

public plugin_init()
{
	new Line[128];
	new Date[8];
	

	plugin_registerinfo("Min to Live Plugin","Let's clients who aren't a member of a server play for x amount of time",STRING_VERSION);
	plugin_registercmd("admin_min","admin_min",1024);

	servertime(Date,MAX_NUMBER_LENGTH,"%d%m");
	readfile(dayFile,Line,1,MAX_NUMBER_LENGTH);

	if (strlen(Line) < 1 || streq(Line,Date) != 1)
	{
		deletefile(dayFile);
		writefile(dayFile,Date,1);
		numtostr(MinToLive,Line);
		writefile(dayFile,Line,2);
	}//end if

	else
	{
		readfile(dayFile,Line,2,128);
		MinToLive = strtonum(Line);
	}//end else

	set_timer("Minute",60,0);

	return PLUGIN_CONTINUE;
}//end plugin_init
