/*
	If you are trying to add commands for the MyCommands plugin then dont look here!
	If you unzipped the stuff right then you have this file:
	addons/adminmod/config/mycommands.ini
	In that file there are plenty of instructions how to configure this plugin.
	Of course - you may just wanna mess with my code. If so - just go ahead :)

	Changelog:

	[1.0] - [1.1]:
	[*] Changed so you now define the admin command.
		That means you now can make admin_buytime instead of the "hard-coded" admin_mp_buytime.
	[*] Added support for non-value commands as "exit" and "restart"
	[*] Added admin_mycommands_reload command for adding any additions from mycommands.ini.
		(Note: This command wont remove any entries! Mapchange needed for that)
	[*] Added more comments
	[*] Misc stuff changed
	
*/

#include <core>
#include <string>
#include <admin>
#include <adminlib>

new STRING_VERSION[MAX_DATA_LENGTH] = "1.1";	// The good old version variable

new Debug = 0;					// Misc debugging.. Handy when you fuck things up
new DebugText[MAX_TEXT_LENGTH];			// Used for the debugging.. (But also for normal error messages)

new AdminCommands[75][MAX_COMMAND_LENGTH];	// max. is 75 commands for now
new ServerCommands[75][MAX_COMMAND_LENGTH];	// max. is 75 commands for now
new CommandType[75] = {0,...};			// max. is 75 commands for now

new FindSlotCommand[MAX_COMMAND_LENGTH];	// Holds the command for findslot() when searching DB

LoadCommands()
	{
	/*
		Reads the file.... Its hard-coded to be addons/adminmod/config/mycommands.ini
		But hey, noone except me actually uses adminmods config folder - Silly them!
	*/
	new Lines = 0;					// Line count
	new Line[MAX_TEXT_LENGTH];			// Content of current line
	new i;						// for() loop

	new Description[MAX_TEXT_LENGTH];		// Description of current command
	new CommandCount = 0;				// The array number for the next command

	new CurrentCommandType = 0;			// Current command type ;)
	new ServerCommand[MAX_COMMAND_LENGTH];		// Current server command ;)
	new AdminCommand[MAX_COMMAND_LENGTH];		// Current admin command ;)
    	new NeededAccess;				// Take a guess...
	new FinalDesc[MAX_TEXT_LENGTH];			// Description compiled into "adminmod format"

	new strCurrentCommandType[MAX_NUMBER_LENGTH];
	new strNeededAccess[MAX_TEXT_LENGTH];

	if (fileexists("addons/adminmod/config/mycommands.ini") == 0)
		{
		log("[MYCOMMANDS] addons/adminmod/config/mycommands.ini not found. Plugin not loading.");
		return PLUGIN_HANDLED;
		}
	
	Lines = (filesize("addons/adminmod/config/mycommands.ini")+1);
	if (Debug)
		{
		snprintf(DebugText, MAX_TEXT_LENGTH, "[MYCOMMANDS] [DEBUG] Filesize: %i",Lines);	
		log(DebugText);
		}

	if (Lines <= 0)
		{
		if(Debug)
			{
			snprintf(DebugText,MAX_TEXT_LENGTH,"[MYCOMMANDS] [DEBUG] Filesize: %i",Lines);
			log(DebugText);
			}
		return PLUGIN_HANDLED;
		}

	for(i=1;i!=Lines+1;i++)
		{
		readfile("addons/adminmod/config/mycommands.ini",Line,i,MAX_TEXT_LENGTH);
		if (Debug)
			{
			snprintf(DebugText,MAX_TEXT_LENGTH,"[MYCOMMANDS] [DEBUG] Reading line %i - Output: %s",i,Line);
			log(DebugText);
			}
		if ((strncmp(Line,"#",1) == 0) || (strncmp(Line,"//",2) == 0) || (strlen(Line) <= 9))
			{
			if(Debug)
				{
				snprintf(DebugText,MAX_TEXT_LENGTH,"[MYCOMMANDS] [DEBUG] Comment/Empty line/Corrupt line detected on line %i",i);
				log(DebugText);
				}
			}
		else
			{
			strsplit(Line,";",strCurrentCommandType,MAX_NUMBER_LENGTH,ServerCommand,MAX_TEXT_LENGTH,AdminCommand,MAX_COMMAND_LENGTH,strNeededAccess,MAX_TEXT_LENGTH,Description,MAX_TEXT_LENGTH);
            		NeededAccess = strtonum(strNeededAccess);
			CurrentCommandType = strtonum(strCurrentCommandType);

			/*
				Damn i love my special way to do advanced if's :D
				Its alot easier this way but i guess it looks stupid in the code.. gah..
			*/
			if
				(
					(strlen(ServerCommand) < 1)
					||
					(strlen(AdminCommand) < 1)
					||
					(strlen(Description) < 1)
					||
					(CurrentCommandType != 1 && CurrentCommandType != 2)
					||
					(NeededAccess < 0)
				)
				{
				snprintf(DebugText,MAX_TEXT_LENGTH,"[MYCOMMANDS] Error: Line %i in addons/adminmod/config/mycommands.ini is corrupted!",i);
				log(DebugText);
				continue; // Skip to next loop
				}

			strcpy(FindSlotCommand,AdminCommand,MAX_COMMAND_LENGTH);
			if (FindSlot() != -1)
				{
				continue; // Skip command if already registered (Should only happen on admin_mycommands_reload)
				}

			snprintf(FinalDesc,MAX_TEXT_LENGTH,"%s: %s",AdminCommand,Description);

			strcpy(AdminCommands[CommandCount],AdminCommand,MAX_TEXT_LENGTH);
			strcpy(ServerCommands[CommandCount],ServerCommand,MAX_TEXT_LENGTH);
			CommandType[CommandCount] = CurrentCommandType;

			CommandCount++;

			plugin_registercmd(AdminCommand,"admin_mycommand",NeededAccess,FinalDesc);
			}
		}
	/*
		Phew. took me some time to figure out how to do everything right..
		Now dont freaking mess with it or im going to kill ya.. This actually works!
	*/
	return PLUGIN_CONTINUE;
	}

public admin_mycommand(HLCommand,HLData,HLUserName,UserIndex)
	{
	new Command[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new Text[MAX_TEXT_LENGTH];
	new User[MAX_NAME_LENGTH];
	new ServerCommand[MAX_DATA_LENGTH];
	new Slot;
	new CurrentCommandType;

	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);
	convert_string(HLUserName,User,MAX_NAME_LENGTH);

	strstripquotes(Data);
	if(Debug)
		{
		snprintf(DebugText,MAX_TEXT_LENGTH,"[MYCOMMANDS] [DEBUG] Admin used command: %s",Command);
		log(DebugText);
		}
	strcpy(FindSlotCommand,Command,MAX_COMMAND_LENGTH);
	Slot = FindSlot();
	if(Slot == -1)
		{
		snprintf(DebugText,MAX_TEXT_LENGTH,"[MYCOMMANDS] Fatal Error: The command ^"%s^" was not found in database! (This should not happen!)",Command);
		log(DebugText);
		return PLUGIN_HANDLED;
		}
	CurrentCommandType = CommandType[Slot];
	strcpy(ServerCommand,ServerCommands[Slot],MAX_COMMAND_LENGTH);
	if (Debug)
		{
		snprintf(DebugText,MAX_TEXT_LENGTH,"[MYCOMMANDS] [DEBUG] Server command appears to be: %s Command type appears to be: %i",ServerCommand,CurrentCommandType);
		log(DebugText);
		}
	if (CurrentCommandType == 1)
		{
		if (strlen(Data) == 0)
			{
			new CurrentValue[MAX_TEXT_LENGTH];
			getstrvar(ServerCommand,CurrentValue,MAX_NAME_LENGTH);
			snprintf(Text,MAX_TEXT_LENGTH,"The current value of %s is: %s",ServerCommand,CurrentValue);
			selfmessage(Text);
			}
		else
			{
			execute_command(User,Command,ServerCommand,Data);
			}
		}
	else
		{
		execute_command(User,Command,ServerCommand,"");
		}
	return PLUGIN_HANDLED;
	}

FindSlot()
	{
	new Command[MAX_COMMAND_LENGTH];	// The Admin command to find in DB
	new i;					// for() loop
	new t = -1;				// What slot the command is in. -1 means not found in DB (Should not happen!)

	strcpy(Command,FindSlotCommand,MAX_COMMAND_LENGTH);

	for(i=0;strlen(AdminCommands[i])>0&&t==-1;i++)
		{
		if (Debug)
			{
			snprintf(DebugText,MAX_TEXT_LENGTH,"[MYCOMMANDS] [DEBUG] Searching slot %i. It contains admin command %s!",i,AdminCommands[i]);
			log(DebugText);
			}
		if(strcmp(AdminCommands[i],Command) == 0)
			{
			if (Debug)
				{
				snprintf(DebugText,MAX_TEXT_LENGTH,"[MYCOMMANDS] [DEBUG] %s seems to be in slot %i. The slot contains: %s",Command,i,AdminCommands[i]);
				log(DebugText);
				}
			t = i;
			}
		}
	return t;
	}

public reloadme(HLCommand,HLData,HLUserName,UserIndex)
	{
	new User[MAX_NAME_LENGTH];
	convert_string(HLUserName,User,MAX_NAME_LENGTH);

	LoadCommands();
	messageex(User,"[MYCOMMANDS] Reloading done. Any new commands from addons/adminmod/config/mycommands.ini has been added!",print_console);

	return PLUGIN_HANDLED;
	}

public plugin_init()
	{
	plugin_registerinfo("MyCommands plugin","Plugin to create an admin command for any server cvar.",STRING_VERSION);
	plugin_registercmd("admin_mycommands_reload","reloadme",ACCESS_RELOAD,"admin_mycommands_reload: Reloads any new commands for the MyCommands plugin.");
	if(getvar("file_access_read") != 1)
		{
		log("[MYCOMMANDS] This plugin requires file_access_read set to 1. Plugin not loading.");
		return PLUGIN_HANDLED;
		}
	LoadCommands();
	return PLUGIN_CONTINUE;
	}